//
//  KeyboardHost.swift
//  VecoreSDKDemo
//
//  Created by Ramon Swilem on 19/09/2019.
//  Copyright © 2019 Ramon Swilem. All rights reserved.
//

import SwiftUI

struct KeyboardHost<Content: View>: View {
    let view: Content

    @State private var keyboardHeight: CGFloat = 0

    //UIApplication.shared.keyWindow?.endEditing(true)
    private let showPublisher = NotificationCenter.Publisher.init(
        center: .default,
        name: UIResponder.keyboardWillShowNotification
    ).map { (notification) -> CGFloat in
        if let rect = notification.userInfo?["UIKeyboardFrameEndUserInfoKey"] as? CGRect {
            return rect.size.height
        } else {
            return 0
        }
    }

    private let hidePublisher = NotificationCenter.Publisher.init(
        center: .default,
        name: UIResponder.keyboardWillHideNotification
    ).map {_ -> CGFloat in 0}

    init(@ViewBuilder content: () -> Content) {
        view = content()
    }

    var body: some View {
        VStack {
            view
            Rectangle()
                .frame(height: keyboardHeight)
                .animation(.easeInOut(duration: 0.3))
                .foregroundColor(.clear)
                .background(Color.white)
        }.onReceive(showPublisher.merge(with: hidePublisher)) { (height) in
            self.keyboardHeight = height
        }.edgesIgnoringSafeArea((self.keyboardHeight > 0 ? .bottom : Edge.Set()))
            .padding(.bottom, 20)
            .onTapGesture {
                UIApplication.shared.sendAction(#selector(UIResponder.resignFirstResponder), to:nil, from:nil, for:nil)
            }
    }
}

struct KeyboardHost_Previews: PreviewProvider {
    static var previews: some View {
        Text("KeyboardHost")
    }
}
